package cn.com.duiba.kjy.api.enums.lottery;

import java.util.Objects;

/**
 * @author lizhi
 * @date 2019/8/1 6:37 PM
 */
public enum LotteryTimesTypeEnum {

    DAILY(0, "永久"),
    FOREVER(1, "每日"),
    ;

    private Integer type;
    private String desc;

    LotteryTimesTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static LotteryTimesTypeEnum getByType(Integer type) {
        if (Objects.isNull(type)) {
            return null;
        }
        for (LotteryTimesTypeEnum timesTypeEnum : values()) {
            if (timesTypeEnum.getType().equals(type)) {
                return timesTypeEnum;
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
