package cn.com.duiba.kjy.api.dto.lottery;

import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2019/8/1 7:20 PM
 */
@Data
public class LotteryPrizeDto implements Serializable {

    private static final long serialVersionUID = -7855698732206819191L;

    private Long id;

    /**
     * 抽奖ID
     */
    private Long lotteryId;

    /**
     * 奖品ID
     */
    private Long prizeId;

    /**
     * 中奖概率
     */
    private Integer prizeRate;

    /**
     * 中奖优先级
     */
    private Integer prizePriority;

    /**
     * 可中次数
     */
    private Integer prizeTimes;

    /**
     * 可中次数类型
     * @see cn.com.duiba.kjy.api.enums.lottery.LotteryTimesTypeEnum
     */
    private Integer prizeTimesType;

    /**
     * 总库存
     */
    private Integer prizeTotalNum;

    /**
     * 剩余库存
     */
    private Integer prizeLeftNum;

    /**
     * 兑吧剩余库存
     */
    private Integer prizeDuiBaLeftNum;

    /**
     * 奖品详情
     */
    private PrizeDto prizeDto;
}
