package cn.com.duiba.kjy.api.enums.seller;


import java.util.Objects;

/**
 * 销售员特权标志位解析枚举
 * @author zhanghuifeng
 * date 2019-06-29-10:42
 */
public enum SellerSpSwitchEnum {

    /**
     * 000
     * 采用二进制位记录销售员特权变动信息
     */
    SITE_SALE_SWITCH_ON(SellerSpPositionEnum.SITE_SALE.getCode(), switchEnum.ON.getCode(), "会销特权开启"),
    SITE_SALE_SWITCH_OFF(SellerSpPositionEnum.SITE_SALE.getCode(), switchEnum.OFF.getCode(), "会销特权关闭"),
    IMPORTANT_FIGURE_SWITCH_ON(SellerSpPositionEnum.IMPORTANT_FIGURE.getCode(), switchEnum.ON.getCode(), "重要节点客户开启"),
    IMPORTANT_FIGURE_SWITCH_OFF(SellerSpPositionEnum.IMPORTANT_FIGURE.getCode(), switchEnum.OFF.getCode(), "重要节点客户关闭"),
    ENOUGH_COMMISSION_SWITCH_ON(SellerSpPositionEnum.ENOUGH_COMMISSION.getCode(), switchEnum.ON.getCode(), "满额返佣特权开启"),
    ENOUGH_COMMISSION_SWITCH_OFF(SellerSpPositionEnum.ENOUGH_COMMISSION.getCode(), switchEnum.OFF.getCode(), "满额返佣特权关闭"),
    ;

    /**
     * 位置
     */
    private Integer position;
    /**
     * 值
     */
    private Integer switchValue;
    /**
     * 描述
     */
    private String desc;

    /**
     * @param switchValue 开关的值（0：关，1：开）
     * @param desc  描述
     */
    SellerSpSwitchEnum(Integer position, Integer switchValue, String desc) {
        this.position = position;
        this.switchValue = switchValue;
        this.desc = desc;
    }

    public Integer getPosition() {
        return position;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 根据值获取枚举类型
     *
     * @param position 枚举值
     * @return 枚举类型
     */
    public static SellerSpSwitchEnum getByPositionAndValue(int position,int switchValue) {
        for (SellerSpSwitchEnum c : SellerSpSwitchEnum.values()) {
            if (Objects.equals(c.getPosition(), position) && Objects.equals(c.getSwitchValue(),switchValue)) {
                return c;
            }
        }
        return null;
    }

    /**
     * 获取当前位置的开关状态值
     * @param position 位置（从1开始）
     * @param dBValue 数据库存储的值
     * @return
     */
    public static int getSwitchValueByPositionAndDBValue(int position,Integer dBValue){
        if (Objects.isNull(dBValue)){
            return switchEnum.OFF.getCode();
        }
        return (dBValue>>(position-1)) & 1;

    }

    public Integer getSwitchValue() {
        return switchValue;
    }

    public enum switchEnum{

        ON(1, "开启"),
        OFF(0, "关闭"),
        ;
        private Integer code;

        private String desc;

        public Integer getCode() {
            return code;
        }

        public String getDesc() {
            return desc;
        }

        switchEnum(Integer code, String desc){
            this.code = code;
            this.desc = desc;
        }

    }

    public enum SellerSpPositionEnum{

        SITE_SALE(1, "会销特权"),
        IMPORTANT_FIGURE(2, "重要节点客户"),
        ENOUGH_COMMISSION(3, "满额返佣特权"),
        ;
        private Integer code;

        private String desc;

        public Integer getCode() {
            return code;
        }

        public String getDesc() {
            return desc;
        }

        SellerSpPositionEnum(Integer code, String desc){
            this.code = code;
            this.desc = desc;
        }

    }


}
