package cn.com.duiba.kjy.api.remoteservice.company;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.company.CompanyContentDto;
import cn.com.duiba.kjy.api.dto.company.ItemCompanyDto;

import java.util.List;
import java.util.Map;

/**
 * item所属公司
 * @author zhanghuifeng
 * date 2019-04-17-20:44
 */
@AdvancedFeignClient
public interface RemoteItemCompanyService {

    /**
     * 根据item信息查询
     * @param itemId
     * @param itemType
     * @return
     */
    List<ItemCompanyDto> findByItem(Long itemId, Integer itemType);

    /**
     * 根据item信息查询名单
     * @param itemId
     * @param itemType
     * @param listType  名单类型, 1=黑名单,0=白名单
     * @return
     */
    List<ItemCompanyDto> findByParams(Long itemId, Integer itemType,Integer listType);

    /**
     * 根据item信息查询
     * @param companyId
     * @param itemType
     * @return
     */
    List<ItemCompanyDto> findByCompany(Long companyId, Integer itemType);

    /**
     * 根据公司ID获取关联item数
     * @param companyId
     * @return
     */
    int findCountByCompany(Long companyId);

    Map<Long/*contentId*/, List<CompanyContentDto>> findMapByItemIds(Integer itemType, List<Long> itemIdList);
}
