package cn.com.duiba.kjy.api.enums.lottery;

import java.util.Objects;

/**
 * @author lizhi
 * @date 2019/8/1 6:58 PM
 */
public enum LotteryNeedTypeEnum {

    NON_NEED(0, "不需要"),
    NEED(1, "需要"),
    ;

    private Integer type;
    private String desc;

    LotteryNeedTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static LotteryNeedTypeEnum getByType(Integer type) {
        if (Objects.isNull(type)) {
            return null;
        }
        for (LotteryNeedTypeEnum needTypeEnum : values()) {
            if (needTypeEnum.getType().equals(type)) {
                return needTypeEnum;
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
