package cn.com.duiba.kjy.api.enums.lottery;

import cn.com.duiba.wolf.utils.DateUtils;

import java.util.Date;
import java.util.Objects;

/**
 * @author lizhi
 * @date 2019/8/1 6:37 PM
 */
public enum LotteryTimesTypeEnum {

    FOREVER(0, "永久"),
    DAILY(1, "每日"),
    ;

    private Integer type;
    private String desc;

    LotteryTimesTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static LotteryTimesTypeEnum getByType(Integer type) {
        if (Objects.isNull(type)) {
            return null;
        }
        for (LotteryTimesTypeEnum timesTypeEnum : values()) {
            if (timesTypeEnum.getType().equals(type)) {
                return timesTypeEnum;
            }
        }
        return null;
    }

    public static String getDateByType(Integer type) {
        LotteryTimesTypeEnum timesTypeEnum = getByType(type);
        if (Objects.isNull(timesTypeEnum)) {
            return "";
        }
        if (DAILY.equals(timesTypeEnum)) {
            return DateUtils.getDayStr(new Date());
        } else if (FOREVER.equals(timesTypeEnum)) {
            return "";
        } else {
            return "";
        }
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
