package cn.com.duiba.kjy.api.dto.activity;

import cn.com.duiba.kjy.api.enums.KjjActivityTypeEnum;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Map;

/**
 * @auther: linjianhui
 * @date: 2019-03-15 19:06
 * @description:
 */
@Data
@ToString
public class ActivityExtDto implements Serializable {

    private static final long serialVersionUID = -8601634767313502374L;

    /**
     * 主键，同tb_content.id
     */
    private Long id;

    /**
     * 标题
     */
    private String title;

    /**
     * 活动链接
     */
    private String activityUrl;

    /**
     * 活动简介
     */
    private String activityDes;

    /**
     * 活动预览图
     */
    private String previewImageUrl;

    /**
     * 活动提供者：duiba=兑吧, kejiji=客集集, kjj_lottery=抽奖游戏库
     * @see cn.com.duiba.kjy.api.enums.ActivityProvideEnum
     */
    private String provide;

    /**
     * 是否参与抽奖,2-不参与,1-参与
     */
    private Integer lottery;

    /**
     * 活动类型：0-其他，1-抽奖，2-测试
     * @see cn.com.duiba.kjy.api.enums.activity.ActivityExtTypeEnum
     *
     */
    private Integer activityExtType;

    /**
     * 抽奖类型：jika=集卡,paoji=炮击,zhuanpan=转盘,coupon=优惠卷
     * @see cn.com.duiba.kjy.api.enums.KjjActivityTypeEnum
     */
    private String activityType;

    /**
     * 备注
     */
    private String remark;


    /**
     * 活动链接
     */
    private String activity_url;

    /**
     * 活动描述
     */
    private String activity_des;

    /**
     * 活动扣库存
     */
    private String stock;

    /**
     * 兑吧中奖规则ID
     */
    private Long ruleId;

    /**
     * 1等奖品名称
     */
    private Map<String, ActivityPrizeBean> prize;

    /**
     * 是否显示Logo 1=显示, 2=不显示
     */
    private Integer showLogo;
}
