package cn.com.duiba.kjy.api.dto;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by zhangshun on 2019/2/20.
 */
@Data
@ToString
public class SellerPayRecordDto implements Serializable {
    private static final long serialVersionUID = -6144048224681700557L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 销售员ID，对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 用户付款金额,单位：分
     */
    private Long amount;

    /**
     * 付款成功时间
     */
    private Date payResultTime;

    /**
     * 付款时间，wxpay=微信
     */
    private String payType;

    /**
     * 付款状态，1=待付款、2=付款中、3=付款成功
     */
    private Integer payStatus;

    /**
     * 交易号
     */
    private String tradeNo;

    private Long userId;

    /**
     * 代付人
     */
    private Long presentUserId;

    /**
     * 套餐id
     */
    private Long comboId;

    /**
     * 邀请码
     */
    private String promotionCode;

    private String exceptionMessage;

    private String dubiaTradeNo;

    /**
     * 备注
     */
    private String remark;

    private String payScene;

    private String payTradeNo;
}
