package cn.com.duiba.kjy.api.params.activity;

import cn.com.duiba.kjy.api.params.ContentSearchParams;
import lombok.Data;

/**
 * @author lizhi
 * @date 2019/8/13 2:16 PM
 */
@Data
public class ActivityExtSearchParams extends ContentSearchParams {

    private static final long serialVersionUID = 7310905348428965345L;

    /**
     * 活动类型：0-其他，1-抽奖，2-测试
     * @see cn.com.duiba.kjy.api.enums.activity.ActivityExtTypeEnum
     */
    private Integer activityExtType;

    /**
     * 是否参与抽奖,2-不参与,1-参与
     */
    private Integer lottery;

    /**
     * 抽奖类型：jika=集卡,paoji=炮击,zhuanpan=转盘,coupon=优惠卷
     * @see cn.com.duiba.kjy.api.enums.KjjActivityTypeEnum
     */
    private String activityType;

    /**
     * 活动提供者：duiba=兑吧, kejiji=客集集, kjj_lottery=抽奖游戏库
     * @see cn.com.duiba.kjy.api.enums.ActivityProvideEnum
     */
    private String provide;
}
