package cn.com.duiba.kjy.api.dto.lottery;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author lizhi
 * @date 2019/8/3 4:06 PM
 */
@Data
public class LotteryWinningRecordDto implements Serializable {

    private static final long serialVersionUID = -1493793034221909888L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 抽奖ID
     */
    private Long lotteryId;

    /**
     * 活动ID，对应tb_content.id
     */
    private Long activityId;

    /**
     * 销售员id，对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 用户ID(销售员)，对应 tb_users.id
     */
    private Long userId;

    /**
     * 活动配置ID，对应tb_activity_conf.id
     */
    private Long activityConfId;

    /**
     * 用户ID(访问者)，对应 tb_users.id
     */
    private Long visitId;

    /**
     * 中奖日期
     */
    private String winningDate;

    /**
     * 奖品ID
     */
    private Long prizeId;

    /**
     * 奖品名称
     */
    private String prizeName;

    /**
     * 奖品图片
     */
    private String prizeImg;

    /**
     * 奖品类型：1-再来一次,2-谢谢参与,3-销售员定制,4-实物,5-链接优惠券
     * @see cn.com.duiba.kjy.api.enums.lottery.PrizeTypeEnum
     */
    private Integer prizeType;

    /**
     * 奖品有效期
     */
    private Date prizeEndTime;

    /**
     * 兑吧奖品扩展信息，比如券地址、券码等
     */
    private String duibaPrizeExt;

    /**
     * 奖品状态：0-未领取，1-已领取，2-已过期
     * @see cn.com.duiba.kjy.api.enums.lottery.PrizeStateEnum
     */
    private Integer prizeState;
}
