package cn.com.duiba.kjy.api.enums.lottery;

/**
 * @author lizhi
 * @date 2019/8/1 8:08 PM
 */
public enum PrizeSourceEnum {

    DUI_BA(1, "兑吧"),
    KE_JI_JI(2, "客集集"),
    SELLER_CUSTOM(3, "销售员定制"),
    ;

    private Integer source;

    private String desc;

    PrizeSourceEnum(Integer source, String desc) {
        this.source = source;
        this.desc = desc;
    }

    public static PrizeSourceEnum getBySource(Integer source) {
        if (source == null) {
            return null;
        }
        for (PrizeSourceEnum sourceEnum : values()) {
            if (sourceEnum.getSource().equals(source)) {
                return sourceEnum;
            }
        }
        return null;
    }

    public Integer getSource() {
        return source;
    }

    public String getDesc() {
        return desc;
    }
}
