package cn.com.duiba.kjy.api.remoteservice.lottery;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.lottery.LotteryDto;
import cn.com.duiba.kjy.api.enums.lottery.LotteryStateEnum;

/**
 * @author lizhi
 * @date 2019/8/2 11:56 AM
 */
@AdvancedFeignClient
public interface RemoteLotteryService {

    /**
     * 根据主键查找抽奖游戏和游戏对应的奖品列表
     * @param id 主键
     * @return 抽奖游戏
     */
    LotteryDto findLotteryAndPrizesById(Long id);

    /**
     * 新增或更新抽奖游戏及奖品配置
     * @param lotteryDto 参数
     * @return true-成功，false-失败
     */
    boolean saveOrUpdateLotteryAndPrizes(LotteryDto lotteryDto);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 抽奖游戏（不包含奖品配置）
     */
    LotteryDto findById(Long id);

    /**
     * 根据主键更新抽奖游戏状态
     * @param id 主键
     * @param stateEnum 状态
     * @return true-成功，false-失败
     */
    boolean updateState(Long id, LotteryStateEnum stateEnum);
}
