package cn.com.duiba.kjy.api.enums;

/**
 * @author zhanghuifeng
 * date 2019-04-17-17:08
 */
public enum ContentPubliclyEnum {

    PUBLICLY(1, "公有"),
    PRIVATE(0, "私有"),
    ;
    private int code;

    private String desc;

    ContentPubliclyEnum(int code, String desc){
        this.code = code;
        this.desc = desc;
    }

    /**
     * x
     * @param code
     * @return
     */
    public static ContentPubliclyEnum getByCode(int code) {
        for (ContentPubliclyEnum enumVal : ContentPubliclyEnum.values()) {
            if (enumVal.getCode()==code) {
                return enumVal;
            }
        }
        return null;
    }

    public static String getDescByCode(int code) {
        for (ContentPubliclyEnum enumVal : ContentPubliclyEnum.values()) {
            if (enumVal.getCode() == code) {
                return enumVal.getDesc();
            }
        }
        return "";
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
