package cn.com.duiba.kjy.api.params;

import cn.com.duiba.kjy.api.constant.ContentTypeEnum;
import lombok.Data;
import lombok.ToString;

import java.util.Date;

/**
 * @auther: linjianhui
 * @date: 2019-02-21 19:56
 * @description: 查询销售发布的文章列表参数
 */
@Data
@ToString
public class SellerContentParams extends PageQuery{

    private static final long serialVersionUID = 813867617440596757L;

    private Long sellerId;

    private String contentType;

    private Date startDate;

    private Date endDate;

    public String getContentTypeLike() {
        if (contentType == null) {
            return null;
        }
        if (ContentTypeEnum.isActivity(contentType)) {
            return ContentTypeEnum.getActivityLike();
        }
        return null;
    }
}
