package cn.com.duiba.kjy.api.params.lottery;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2019/8/8 7:19 PM
 */
@Data
public class LotteryWinningRecordParams extends PageQuery {

    private static final long serialVersionUID = -87258617652100570L;

    /**
     * 抽奖ID
     */
    private Long lotteryId;

    /**
     * 活动ID，对应tb_content.id
     */
    private Long activityId;

    /**
     * 销售员id，对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 用户ID(销售员)，对应 tb_users.id
     */
    private Long userId;

    /**
     * 活动配置ID，对应tb_activity_conf.id
     */
    private Long activityConfId;

    /**
     * 用户ID(访问者)，对应 tb_users.id
     */
    private Long visitId;

    /**
     * 中奖日期
     */
    private String winningDate;

    /**
     * 奖品ID
     */
    private Long prizeId;

    /**
     * 是否删除，1=已删除，0=未删除
     * @see cn.com.duiba.kjy.api.enums.DeletedEnum
     */
    private Integer deleted;
}
