package cn.com.duiba.kjy.api.enums.lottery;

import java.util.Objects;

/**
 * @author lizhi
 * @date 2019/8/1 6:43 PM
 */
public enum LotteryRuleEnum {

    RATE(0, "概率"),
    PRIORITY(1, "优先级"),
    ;

    private Integer rule;
    private String desc;

    LotteryRuleEnum(Integer rule, String desc) {
        this.rule = rule;
        this.desc = desc;
    }

    public static LotteryRuleEnum getByRule(Integer rule) {
        if (Objects.isNull(rule)) {
            return null;
        }
        for (LotteryRuleEnum ruleEnum : values()) {
            if (ruleEnum.getRule().equals(rule)) {
                return ruleEnum;
            }
        }
        return null;
    }

    public Integer getRule() {
        return rule;
    }

    public String getDesc() {
        return desc;
    }
}
