package cn.com.duiba.kjy.api.enums.lottery;

/**
 * @author lizhi
 * @date 2019/8/9 11:19 AM
 */
public enum LotteryStateEnum {
    DRAFT(0, "草稿"),
    OPEN(1, "开启"),
    CLOSE(2, "关闭"),
    ;

    private Integer type;

    private String desc;

    LotteryStateEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static LotteryStateEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        for (LotteryStateEnum stateEnum : values()) {
            if (stateEnum.getType().equals(type)) {
                return stateEnum;
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
