package cn.com.duiba.kjy.api.remoteservice.lottery;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.lottery.LotteryDto;
import cn.com.duiba.kjy.api.enums.lottery.LotteryStateEnum;
import cn.com.duiba.kjy.api.params.lottery.LotteryParams;

import java.util.List;

/**
 * @author lizhi
 * @date 2019/8/2 11:56 AM
 */
@AdvancedFeignClient
public interface RemoteLotteryService {

    /**
     * 分页查询抽奖游戏列表
     * @param params 参数
     * @return 列表
     */
    List<LotteryDto> selectPage(LotteryParams params);

    /**
     * 查询条数
     * @param params 参数
     * @return 条数
     */
    int selectCount(LotteryParams params);

    /**
     * 根据主键查找抽奖游戏和游戏对应的奖品列表
     * @param id 主键
     * @return 抽奖游戏
     */
    LotteryDto findLotteryAndPrizesById(Long id);

    /**
     * 新增或更新抽奖游戏及奖品配置
     * @param lotteryDto 参数
     * @return true-成功，false-失败
     */
    boolean saveOrUpdateLotteryAndPrizes(LotteryDto lotteryDto);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 抽奖游戏（不包含奖品配置）
     */
    LotteryDto findById(Long id);

    /**
     * 根据主键更新抽奖游戏状态
     * @param id 主键
     * @param stateEnum 状态
     * @return true-成功，false-失败
     */
    boolean updateState(Long id, LotteryStateEnum stateEnum);

    /**
     * 根据主键，获取活动配置URL
     * @param id 主键
     * @return 活动配置页面的URL
     */
    String getActivityUrlById(Long id);

    /**
     * 根据链接获取抽奖活动ID
     * @param url 活动配置链接
     * @return 抽奖活动ID
     */
    Long getLotteryIdByActivityUrl(String url);

    /**
     * 根据主键集合查询
     * @param ids 主键集合
     * @return 抽奖游戏列表
     */
    List<LotteryDto> findByIds(List<Long> ids);

    /**
     * 根据活动ID获取抽奖游戏信息
     * @param activityId 活动ID
     * @return 抽奖游戏信息
     */
    LotteryDto findLotteryAndPrizesByActivityId(Long activityId);
}
