package cn.com.duiba.kjy.api.remoteservice.lottery;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.lottery.LotteryWinningRecordDto;
import cn.com.duiba.kjy.api.enums.lottery.PrizeStateEnum;
import cn.com.duiba.kjy.api.params.lottery.LotteryWinningRecordParams;

import java.util.List;

/**
 * @author lizhi
 * @date 2019/8/3 4:11 PM
 */
@AdvancedFeignClient
public interface RemoteLotteryWinningRecordService {

    /**
     * 分页查询中奖记录
     * @param params 参数
     * @return 中奖记录
     */
    List<LotteryWinningRecordDto> findPage(LotteryWinningRecordParams params);

    /**
     * 查询中奖记录总条数
     * @param params 参数
     * @return 总条数
     */
    int selectCount(LotteryWinningRecordParams params);

    /**
     * 更新奖品状态
     * @param id 主键
     * @param stateEnum 状态枚举
     * @return true-成功，false-失败
     */
    boolean updateState(Long id, PrizeStateEnum stateEnum);
}
