/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.enums.lottery;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public enum PrizeTypeEnum {
    THANKS(1, "\u8c22\u8c22\u53c2\u4e0e"),
    AGAIN(2, "\u518d\u6765\u4e00\u6b21"),
    SELLER_CUSTOM(3, "\u9500\u552e\u5458\u5b9a\u5236"),
    COUPON_LINK(4, "\u94fe\u63a5\u4f18\u60e0\u5238"),
    OBJECT(5, "\u5b9e\u7269");

    private Integer type;
    private String desc;
    private static final Map<Integer, PrizeTypeEnum> ENUM_MAP;

    private PrizeTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static PrizeTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    public static boolean isWinning(Integer type) {
        if (Objects.isNull(type)) {
            return false;
        }
        return !Objects.equals(type, AGAIN.getType()) && !Objects.equals(type, THANKS.getType());
    }

    public boolean notWinningTimesLimit() {
        return this == THANKS || this == AGAIN;
    }

    public boolean notStockLimit() {
        return this == THANKS || this == AGAIN;
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        ENUM_MAP = new HashMap<Integer, PrizeTypeEnum>();
        for (PrizeTypeEnum typeEnum : PrizeTypeEnum.values()) {
            ENUM_MAP.put(typeEnum.getType(), typeEnum);
        }
    }
}

