/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.util;

public class IdConverter {
    private static final int PRE_LENGTH = 3;

    public static Long encodeId(Long id) {
        return IdConverter.encode(id, 12);
    }

    public static Long encodeOrderId(Long id) {
        return IdConverter.encode(id, 19);
    }

    private static Long encode(Long id, int totalLength) {
        if (id == null) {
            return null;
        }
        if (id <= 0L) {
            return id;
        }
        String idStr = String.valueOf(id);
        int idLength = idStr.length();
        if (idLength + 3 > totalLength) {
            return -1L;
        }
        String pre = IdConverter.getPre(idLength);
        String encodeIdStr = IdConverter.getEncodeIdStr(idStr);
        String replaceStr = IdConverter.getReplaceStr(encodeIdStr, totalLength - 3 - idLength);
        return Long.parseLong(pre + replaceStr + encodeIdStr);
    }

    public static Long decode(Long id) {
        if (id == null) {
            return null;
        }
        if (id <= 0L) {
            return id;
        }
        String s = String.valueOf(id);
        if (s.length() <= 3) {
            return -1L;
        }
        String encodeIdStr = IdConverter.getEncodeIdStrById(s);
        String decodeIdStr = IdConverter.getDecodeIdStr(encodeIdStr);
        return Long.parseLong(decodeIdStr);
    }

    private static String getPre(int length) {
        String lengthStr = String.valueOf(length);
        if (lengthStr.length() < 2) {
            return "10" + lengthStr;
        }
        return "1" + lengthStr;
    }

    private static String getReplaceStr(String encodeIdStr, int replaceLength) {
        if (replaceLength <= 0) {
            return "";
        }
        int num = replaceLength - encodeIdStr.length();
        String replaceStr = num < 0 ? encodeIdStr.substring(0, replaceLength) : (num == 0 ? encodeIdStr : IdConverter.getZero(num / 2) + encodeIdStr + IdConverter.getZero(num - num / 2));
        return IdConverter.replace(replaceStr);
    }

    private static String replace(String replaceStr) {
        char[] chars = replaceStr.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            int num = Integer.parseInt(String.valueOf(chars[i])) + i + 1;
            int pow = num * num;
            int yu = (num + i) % 10;
            if (yu == 0) {
                yu = 10;
            }
            int result = pow % yu;
            chars[i] = (char)(result + 48);
        }
        return new String(chars);
    }

    private static String getZero(int num) {
        if (num <= 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < num; ++i) {
            sb.append("0");
        }
        return sb.toString();
    }

    private static String getEncodeIdStrById(String s) {
        String substring = s.substring(1, 3);
        int idLength = Integer.parseInt(substring);
        return s.substring(s.length() - idLength);
    }

    private static String getEncodeIdStr(String idStr) {
        char[] chars = idStr.toCharArray();
        IdConverter.convert(chars);
        IdConverter.exchange(chars);
        return new String(chars);
    }

    private static String getDecodeIdStr(String encodeIdStr) {
        char[] chars = encodeIdStr.toCharArray();
        IdConverter.decodeExchange(chars);
        IdConverter.decodeConvert(chars);
        return new String(chars);
    }

    private static void decodeExchange(char[] chars) {
        IdConverter.exchange(chars);
    }

    private static void exchange(char[] chars) {
        for (int i = 0; i < chars.length / 2; ++i) {
            int index = i * 2;
            char temp = chars[index];
            chars[index] = chars[index + 1];
            chars[index + 1] = temp;
        }
    }

    private static void decodeConvert(char[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            int num = Integer.parseInt(String.valueOf(chars[i]));
            num = num >= 7 ? (num -= 7) : (num += 3);
            chars[i] = (char)(num + 48);
        }
    }

    private static void convert(char[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            int num = Integer.parseInt(String.valueOf(chars[i]));
            num = (num + 7) % 10;
            chars[i] = (char)(num + 48);
        }
    }

    public static void main(String[] args) {
        for (long i = 0L; i < 10000000000000000L; ++i) {
            Long decode = IdConverter.decode(IdConverter.encodeOrderId(i));
            if (decode == i) continue;
            System.out.println(i);
            return;
        }
    }

    public static void test(Long id) {
        Long encode = IdConverter.encodeOrderId(id);
        System.out.println(encode);
        Long decode = IdConverter.decode(encode);
        System.out.println(decode);
    }
}

