package cn.com.duiba.kjy.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.seller.DistributionAwardRuleDto;
import cn.com.duiba.kjy.api.dto.seller.SellerAwardRuleDto;
import cn.com.duiba.kjy.api.enums.seller.DistributionTypeEnum;

import java.util.List;

/**
 * 销售员分销返佣规则服务
 * @author zhanghuifeng
 * date 2019-07-04-16:51
 */
@AdvancedFeignClient
public interface RemoteSellerAwardRuleService {

    /**
     * 根据销售员ID和分销返佣规则类型查询
     * @param sellerId
     * @param disRuleTypeEnum
     * @return
     */
    DistributionAwardRuleDto findBySellerIdAndRuleType(Long sellerId, DistributionTypeEnum disRuleTypeEnum);

    /**
     * 新增销售员分销返佣规则
     * @param dto
     * @return
     */
    Boolean add(SellerAwardRuleDto dto);

    /**
     * 更新销售员分销返佣规则
     * @param dto
     * @return
     */
    Boolean update(SellerAwardRuleDto dto);

    /**
     * 根据销售员ID和分销返佣规则类型查询
     * @param sellerId
     * @param disRuleTypeEnum
     * @return
     */
    int countBySellerIdAndRuleType(Long sellerId, DistributionTypeEnum disRuleTypeEnum);

    /**
     * 开通会员成功后插入销售员默认分销奖励规则
     * @param sellerId
     * @param typeEnum
     */
    Boolean insertSellerDefaultAwardRule(Long sellerId, DistributionTypeEnum typeEnum);

    /**
     * 新增（存在则更新）
     * @param dto
     * @return
     */
    Boolean insertExistUpdate(SellerAwardRuleDto dto);

    /**
     * 根据销售员ID集合和规则类型集合查询
     * @param sellerIds
     * @param ruleTypes
     * @see DistributionTypeEnum
     * @return
     */
    List<SellerAwardRuleDto> listBySellerRuleTypes(List<Long> sellerIds, List<Integer> ruleTypes);
}
