package cn.com.duiba.kjy.api.dto.interaction;

import cn.com.duiba.kjy.api.dto.contentinteractionoption.ContentInteractionOptionDto;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author lizhi
 * @date 2019/8/30 3:45 PM
 */
@Data
public class ContentInteractionTableFieldDto implements Serializable {

    private static final long serialVersionUID = 8713106449134354626L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 互动ID，tb_content_interaction_question.id
     */
    private Long interactionId;

    /**
     * 字段名称
     */
    private String fieldName;

    /**
     * 字段类型，0-文字，1-长文字，2-单选，3-多选，4，下拉框，5-日期，6-地址
     * @see cn.com.duiba.kjy.api.enums.interaction.InteractionTableFieldTypeEnum
     */
    private Integer fieldType;

    /**
     * 字段排序
     */
    private Integer fieldSort;

    /**
     * 选项类型的字段的选项列表
     */
    private List<ContentInteractionOptionDto> options;
}
