package cn.com.duiba.kjy.api.enums.interaction;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2019/8/30 3:34 PM
 */
public enum InteractionTableFieldTypeEnum {

    TEXT(0, "文字"),
    MEDIUMTEXT(1, "长文字"),
    SINGLE_SELECTION(2, "单选"),
    MULTIPLE_SELECTION(3, "多选"),
    COMBO_BOX(4, "下拉框"),
    DATE(5, "日期"),
    ADDRESS(6, "地址"),
    ;

    private Integer type;

    private String desc;

    InteractionTableFieldTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, InteractionTableFieldTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(InteractionTableFieldTypeEnum typeEnum : values()){
            ENUM_MAP.put(typeEnum.getType(), typeEnum);
        }
    }

    public static InteractionTableFieldTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    /**
     * 是否需要选项
     * @param type 类型
     * @return true-需要选项，false-不需要
     */
    public static boolean isNeedOptions(Integer type) {
        InteractionTableFieldTypeEnum typeEnum = getByType(type);
        if (typeEnum == null) {
            return false;
        }
        return typeEnum == SINGLE_SELECTION || typeEnum == MULTIPLE_SELECTION || typeEnum == COMBO_BOX;
    }
}
