package cn.com.duiba.kjy.api.params.interaction;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;

/**
 * @author lizhi
 * @date 2019/8/30 4:16 PM
 */
@Data
public class ContentInteractionTemplateSearchParams extends PageQuery {

    private static final long serialVersionUID = -6154134061053909883L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 标题
     */
    private String title;

    /**
     * 模板类型, 0-投票，1-答题，2-表格
     * @see cn.com.duiba.kjy.api.enums.interaction.InteractionTemplateTypeEnum
     */
    private Integer templateType;

    /**
     * 选择类型，0-单选，1-多选
     * @see cn.com.duiba.kjy.api.enums.interaction.InteractionTemplateSelectionTypeEnum
     */
    private Integer selectionType;

    /**
     * 状态：0-草稿，1-启用，2-停用
     * @see cn.com.duiba.kjy.api.enums.interaction.InteractionTemplateStateEnum
     */
    private Integer state;
}
