/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.enums.interaction;

import java.util.HashMap;
import java.util.Map;

public enum InteractionTypeEnum {
    OPTION_SINGLE((byte)0, "\u95ee\u7b54\u9898\u5355\u9009"),
    OPTION_MULTI((byte)1, "\u95ee\u7b54\u9898\u591a\u9009"),
    VOTE_SINGLE((byte)2, "\u6295\u7968\u5355\u9009"),
    VOTE_MULTI((byte)3, "\u6295\u7968\u591a\u9009");

    private Byte type;
    private String desc;
    private static final Map<Byte, InteractionTypeEnum> ENUM_MAP;

    private InteractionTypeEnum(Byte type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Byte getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public static boolean isOption(Byte type) {
        InteractionTypeEnum typeEnum = InteractionTypeEnum.getByType(type);
        if (typeEnum == null) {
            return false;
        }
        return typeEnum == OPTION_SINGLE || typeEnum == OPTION_MULTI;
    }

    public static boolean isVote(Byte type) {
        InteractionTypeEnum typeEnum = InteractionTypeEnum.getByType(type);
        if (typeEnum == null) {
            return false;
        }
        return typeEnum == VOTE_SINGLE || typeEnum == VOTE_MULTI;
    }

    public static InteractionTypeEnum getByType(Byte type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    static {
        ENUM_MAP = new HashMap<Byte, InteractionTypeEnum>();
        for (InteractionTypeEnum typeEnum : InteractionTypeEnum.values()) {
            ENUM_MAP.put(typeEnum.getType(), typeEnum);
        }
    }
}

