package cn.com.duiba.kjy.api.enums.material;

import cn.com.duiba.kjy.api.enums.interaction.InteractionTypeEnum;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author 吴文哲
 * @date 2019-09-09 16:56
 **/
public enum SellerCustomerMaterialTypeEnum {

    INTERACTION_ANSWER_SINGLE(100, "问答题单选"),
    INTERACTION_ANSWER_MULTIPLE(101, "问答题多选"),
    INTERACTION_VOTE_SINGLE(102, "投票单选"),
    INTERACTION_VOTE_MULTIPLE(103, "投票多选"),

    INTERACTION_SELLER_ANSWER_SINGLE(104, "销售员配置答题单选"),
    INTERACTION_SELLER_ANSWER_MULTIPLE(105, "销售员配置答题多选"),
    INTERACTION_SELLER_VOTE_SINGLE(106, "销售员配置投票单选"),
    INTERACTION_SELLER_VOTE_MULTIPLE(107, "销售员配置投票多选"),
    INTERACTION_SELLER_TABLE(108, "销售员配置表格"),
    ;
    private Integer type;

    private String desc;

    SellerCustomerMaterialTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 是否是互动
     * @return true-是，false-否
     */
    public boolean isInteraction() {
        return this.getType() < 200;
    }

    public static List<Integer> getAllInteraction(){
        List<Integer> resultList = new ArrayList<>();
        for(SellerCustomerMaterialTypeEnum val: SellerCustomerMaterialTypeEnum.values()){
            //小于200都是互动
            if(val.getType()<200){
                resultList.add(val.getType());
            }
        }
        return resultList;
    }

    /**
     * 获取所有答题
     * @return
     */
    public static List<Integer> getAllOptionInteraction(){
        return Arrays.asList(INTERACTION_ANSWER_SINGLE.type,INTERACTION_ANSWER_MULTIPLE.type,
                INTERACTION_SELLER_ANSWER_SINGLE.type,INTERACTION_SELLER_ANSWER_MULTIPLE.type);
    }

    /**
     * 获取所有投票
     * @return
     */
    public static List<Integer> getAllVoteInteraction(){
        return Arrays.asList(INTERACTION_VOTE_SINGLE.type,INTERACTION_VOTE_MULTIPLE.type,
                INTERACTION_SELLER_VOTE_SINGLE.type,INTERACTION_SELLER_VOTE_MULTIPLE.type);
    }
    /**
     * 是否为后台配置的答题
     * @param type
     * @return
     */
    public static boolean isManagerOption(Integer type){
        SellerCustomerMaterialTypeEnum typeEnum = SellerCustomerMaterialTypeEnum.getByType(type);
        if(Objects.nonNull(typeEnum) && (typeEnum.equals(SellerCustomerMaterialTypeEnum.INTERACTION_ANSWER_SINGLE) ||
                typeEnum.equals(SellerCustomerMaterialTypeEnum.INTERACTION_ANSWER_MULTIPLE))){
            return true;
        }
        return false;
    }

    /**
     * 是否为后台配置的投票
     * @param type
     * @return
     */
    public static boolean isManagerVote(Integer type){
        SellerCustomerMaterialTypeEnum typeEnum = SellerCustomerMaterialTypeEnum.getByType(type);
        if(Objects.nonNull(typeEnum) && (typeEnum.equals(SellerCustomerMaterialTypeEnum.INTERACTION_VOTE_SINGLE) ||
                typeEnum.equals(SellerCustomerMaterialTypeEnum.INTERACTION_VOTE_MULTIPLE))){
            return true;
        }
        return false;

    }

    private static final Map<Integer, SellerCustomerMaterialTypeEnum> ENUM_MAP = new HashMap<>();

    static{
        for(SellerCustomerMaterialTypeEnum typeEnum : values()){
            ENUM_MAP.put(typeEnum.getType(), typeEnum);
        }
    }

    public static SellerCustomerMaterialTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    public static SellerCustomerMaterialTypeEnum getByInteractionTypeEnum(InteractionTypeEnum interactionTypeEnum) {
        if (interactionTypeEnum == null) {
            return null;
        }
        Integer type = (int)interactionTypeEnum.getType();
        return getByType(type + 100);
    }
}
