package cn.com.duiba.kjy.api.dto.fission;


import cn.com.duiba.kjy.api.enums.fission.AwardTypeEnum;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

/**
 *
 * @author : liuchao1@duiba.com.cn
 * @version V1.0
 * @date 2019年10月28日 11:32
 **/

@Data
@ToString
public class AwardDto implements Serializable {
    private static final long serialVersionUID = -2402155353398682958L;

    /**
     * 奖品id
     */
    private Long id;

    /**
     * 奖品名称
     */
    private String name;

    /**
     * 涨粉人数
     */
    private Integer fansNum;

    /**
     * 海报id
     */
    private Long posterId;

    /**
     * 涨粉文案
     */
    private String fansText;

    /**
     * 是否启用
     */
    private boolean halted;

    /**
     * 目标助力人数
     */
    private Integer targetAssistanceNum;

    /**
     * 价值
     */
    private String worth;

    /**
     * 奖品类型
     * @see AwardTypeEnum
     */
    private String type;

    /**
     * 奖品资源地址
     */
    private String resourceUrl;

    /**
     * 标签
     */
    private List<String> tags;

    /**
     * 该奖品涨粉人图像集合
     */
    private List<String> fansIcons;

    /**
     * 奖品海报地址
     */
    private String imageUrl;

    /**
     * 资源图标链接
     */
    private String resourceIconUrl;

    /**
     * 资源操作图标链接
     */
    private String resourceOperateIconUrl;
}
