package cn.com.duiba.kjy.api.enums;

/**
 * 标签分类枚举
 * @author zhanghuifeng
 * date 2019-04-12-11:14
 */
public enum TagTypeEnum {

    ARTICLE("article", "文章"),
    ACTIVITY("activity", "活动"),
    POSTER("poster", "海报"),
    GAME_LOTTERY("game_lottery", "抽奖工具"),
    ;
    private String code;

    private String desc;

    TagTypeEnum(String code, String desc){
        this.code = code;
        this.desc = desc;
    }

    /**
     * x
     * @param code
     * @return
     */
    public static TagTypeEnum getByCode(String code) {
        for (TagTypeEnum enumVal : TagTypeEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public static String getDescByCode(String code) {
        for (TagTypeEnum enumVal : TagTypeEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal.getDesc();
            }
        }
        return "";
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
