package cn.com.duiba.kjy.api.dto.lottery;

import lombok.Data;

import java.io.Serializable;

/**
 * @author lizhi
 * @date 2019/10/23 2:54 PM
 */
@Data
public class LotteryOrderDto implements Serializable {

    private static final long serialVersionUID = -7471785312383033722L;

    /**
     * 订单ID
     */
    private Long id;

    /**
     * 抽奖ID
     */
    private Long lotteryId;

    /**
     * 活动ID，对应tb_content.id
     */
    private Long activityId;

    /**
     * 销售员id，对应tb_seller.id
     */
    private Long sellerId;

    /**
     * 用户ID(销售员)，对应 tb_users.id
     */
    private Long sellerUserId;

    /**
     * 活动配置ID，对应tb_seller_activity_conf.id
     */
    private Long activityConfId;

    /**
     * 用户ID(访问者)，对应 tb_users.id
     */
    private Long visitorId;

    /**
     * 访问者昵称
     */
    private String visitorNickname;

    /**
     * 奖品ID
     */
    private Long prizeId;

    /**
     * 奖品类型：1-谢谢参与,2-再来一次,3-销售员定制,4-链接优惠券,5-实物
     * @see cn.com.duiba.kjy.api.enums.lottery.PrizeTypeEnum
     */
    private Integer prizeType;

    /**
     * 错误码
     */
    private String errorCode;

    /**
     * 状态=0-未出奖，1-出奖中，2-出奖成功，3-出奖异常
     * @see cn.com.duiba.kjy.api.enums.lottery.LotteryOrderStateEnum
     */
    private Integer state;
}
