package cn.com.duiba.kjy.api.constant;


import org.apache.commons.lang.StringUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by zhangshun on 2019/2/13.
 */
public enum ContentTypeEnum {

    /**
     * 内容类型
     */
    ARTICLE("article", "文章"),
    ACTIVITY("activity", "活动"),
    DAILY("daily", "早报"),
    POSTER("poster", "海报"),
    AFTERNOON("afternoon", "午后话题"),
    EVENING("evening", "晚安心语"),
    GAME_LOTTERY("game_lottery", "抽奖工具"),
    GAME_ANSWER("game_answer", "小游戏"),

    // 访问记录的类型
    @Deprecated
    SELLER("seller", "销售员名片"),
    /**
     * 新版名片，不兼容老版。设立新类型
     */
    SELLER_CARD("card", "名片分享"),
    OUTER_MARKET("outer_market", "腰封自定义链接"),
    OUTER_EXCLUSIVE("outer_exclusive", "专区自定义链接"),
    WEEKLY_PUBLICATION("weekly_publication", "代理人周报"),
    ;

    private String code;
    private String desc;

    ContentTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<String, ContentTypeEnum> ENUM_MAP = new HashMap<>();

    static {
        for (ContentTypeEnum type : values()) {
            ENUM_MAP.put(type.getCode(), type);
        }
    }

    public static ContentTypeEnum getByCode(String code) {
        ContentTypeEnum result = ENUM_MAP.get(code);
        if (result == null) {
            return null;
        }
        return result;
    }

    public static boolean isContent(String type) {
        return StringUtils.equals(type, ARTICLE.code) ||
                StringUtils.equals(type, ACTIVITY.code) ||
                StringUtils.equals(type, DAILY.code) ||
                StringUtils.equals(type, POSTER.code) ||
                StringUtils.equals(type, AFTERNOON.code) ||
                StringUtils.equals(type, EVENING.code) ||
                StringUtils.equals(type, GAME_LOTTERY.code)
                ;
    }

    public static boolean isNeedAnalyse(String type) {
        return StringUtils.equals(type, ARTICLE.code) ||
                StringUtils.equals(type, ACTIVITY.code) ||
                StringUtils.equals(type, DAILY.code) ||
                StringUtils.equals(type, EVENING.code) ||
                StringUtils.equals(type, OUTER_EXCLUSIVE.code) ||
                StringUtils.equals(type, OUTER_MARKET.code) ||
                StringUtils.equals(type, GAME_LOTTERY.code)
                ;
    }

    public static boolean isPaper(String type) {
        return StringUtils.equals(type, DAILY.code) ||
                StringUtils.equals(type, AFTERNOON.code) ||
                StringUtils.equals(type, EVENING.code)
                ;
    }

    /**
     * 获取不需要统计的内容类型
     *
     * @return
     */
    public static List<String> getUnNeedAnalyseTypes() {
        List<String> resultList = new ArrayList<>();
        resultList.add(ContentTypeEnum.POSTER.getCode());
        resultList.add(ContentTypeEnum.SELLER_CARD.getCode());
        return resultList;
    }

    public static boolean isMarket(String type) {
        return StringUtils.equals(type, OUTER_MARKET.code);
    }

    public static boolean isSellerCard(String type) {
        return StringUtils.equals(type, SELLER_CARD.code);
    }

    public static boolean isExclusive(String type) {
        return StringUtils.equals(type, OUTER_EXCLUSIVE.code);
    }

    public static boolean isSeller(String type) {
        return StringUtils.equals(type, SELLER.code);
    }

    public static boolean isActivity(String type) {
        return StringUtils.equals(type, ACTIVITY.code) ||
                isGameActivity(type)
                ;
    }

    public static boolean isGameActivity(String type) {
        return StringUtils.equals(type, GAME_LOTTERY.code) ||
                StringUtils.equals(type, GAME_ANSWER.code);
    }

    public static List<String> getGameActivityContentTypes() {
        List<String> list = new ArrayList<>();
        for (ContentTypeEnum typeEnum : values()) {
            if (isGameActivity(typeEnum.code)) {
                list.add(typeEnum.code);
            }
        }
        return list;
    }

    /**
     * 新手任务 是否为文章类型 包括文章 早报 晚报
     * @param type
     * @return
     */
    public static boolean isNoviceTaskArticleType(String type) {
        return StringUtils.equals(type, ARTICLE.code)
                || StringUtils.equals(type, DAILY.code)
                || StringUtils.equals(type, EVENING.code);
    }

    /**
     * 新手任务 是否为动画类型
     * @param type
     * @return
     */
    public static boolean isNoviceTaskActivityType(String type) {
        return StringUtils.equals(type, ACTIVITY.code);
    }

}
