package cn.com.duiba.kjy.api.remoteservice.content;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.constant.KjyCenterException;
import cn.com.duiba.kjy.api.dto.contentarticle.AdminArticleCollectionDto;
import cn.com.duiba.kjy.api.params.content.ArticleListParam;

import java.util.Date;
import java.util.List;

/**
 * Created by dugq on 2019-11-16.
 */
@AdvancedFeignClient
public interface RemoteAdminArticleCollectionService {

    AdminArticleCollectionDto selectOne(Long id);

    /**
     * 插入一条新收藏
     * @param dto
     * @return 记录ID
     */
    Long insert(AdminArticleCollectionDto dto);

    /**
     * 为已经定时的收藏文章排序
     *
     * @param id
     * @param type
     * @return  已经发布的或者未定时的 return 0;
     */
    int sort(Long id ,Byte type);

    /**
     * 列表查询
     * @param param
     * @return
     */
    List<AdminArticleCollectionDto> selectList(ArticleListParam param);

    /**
     * 和查询配套使用
     * 查询数量
     * @param param
     * @return
     */
    long selectCount(ArticleListParam param);

    /**
     * 批量定时,并设置标签
     * @param ids
     * @param time
     * @return
     */
    int batchTimingOpen(List<Long> ids, Date time,List<Long> firstTagId);

    /**
     * 批量删除
     * @param ids
     * @return 返回删除条数
     */
    int batchDelete(List<Long> ids);

    /**
     * 发布
     * @return
     */
    int publish(Long id,boolean publish) throws KjyCenterException;


    int update(AdminArticleCollectionDto dto);
}
