package cn.com.duiba.kjy.api.dto.fission;


import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 *
 * @author : liuchao1@duiba.com.cn
 * @version V1.0
 * @date 2019年10月28日 11:32
 **/

@Data
@ToString
public class FissionAwardDto implements Serializable {
    private static final long serialVersionUID = -2402155353398682958L;

    /**
     * 奖品id
     */
    private Long id;

    /**
     * 奖品名称
     */
    private String awardName;

    /**
     * 涨粉人数
     */
    private Integer fansNum;

    /**
     * 涨粉文案
     */
    private String fansText;

    /**
     * 是否启用
     * @see cn.com.duiba.kjy.api.enums.fission.FissionAwardHaltedEnum
     */
    private Integer halted;

    /**
     * 目标助力人数
     */
    private Integer targetAssistanceNum;

    /**
     * 标签
     */
    private String tags;

    /**
     * 该奖品涨粉人图像集合
     */
    private List<String> fansIcons;

    /**
     * 奖品海报地址
     */
    private String imageUrl;

    /**
     * 字体颜色
     */
    private String fontColor;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}
