package cn.com.duiba.kjy.api.enums.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 代理人配置key枚举
 *
 * @author 吴文哲
 * @date 2019-11-19 15:35
 **/
public enum SellerConfigKeyEnum {
    CARD_SHOW_ON_TOP("card_show_on_top", "向客户展示文章顶部名片",true),
    CARD_SHOW_ON_BOTTOM("card_show_on_bottom", "向客户展示文章底部名片",true);



    /**
     * 键  长度限制30
     */
    private String key;
    /**
     * 描述  长度限制500
     */
    private String desc;

    private Object defaultVal;

    SellerConfigKeyEnum(String key, String desc,Object defaultVal) {
        this.key = key;
        this.desc = desc;
        this.defaultVal = defaultVal;
    }

    public String getKey() {
        return key;
    }

    public String getDesc() {
        return desc;
    }


    public Object getDefaultVal() {
        return defaultVal;
    }

    private static final Map<String, SellerConfigKeyEnum> ENUM_MAP = new HashMap<>();

    private static final List<String> BOOLEAN_LIST = new ArrayList<>();

    static{
        for(SellerConfigKeyEnum configEnum : values()){
            ENUM_MAP.put(configEnum.getKey(), configEnum);
        }
        //添加boolean类型的枚举
        BOOLEAN_LIST.addAll(Arrays.asList(CARD_SHOW_ON_TOP.getKey(),CARD_SHOW_ON_BOTTOM.getKey()));
    }

    public static SellerConfigKeyEnum getByType(String  key) {
        if (key == null) {
            return null;
        }
        return ENUM_MAP.get(key);
    }

    /**
     * 获取所有的Boolean类型的枚举
     * @return
     */
    public static List<String> getBooleanEnums() {
        return BOOLEAN_LIST;
    }
}
