package cn.com.duiba.kjy.api.remoteservice.push;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.push.PushManagerDto;
import cn.com.duiba.kjy.api.params.push.PushManagerSearchParam;

import java.util.List;

/**
 * @auther: linjianhui
 * @date: 2019-08-06 14:31
 * @description: 推送管理
 */
@AdvancedFeignClient
public interface RemotePushManagerService {

    /**
     * 查询推送管理列表
     *
     * @param param
     * @return
     */
    List<PushManagerDto> selectList(PushManagerSearchParam param);

    /**
     * 查询列表条数
     *
     * @param param
     * @return
     */
    Long selectCount(PushManagerSearchParam param);

    /**
     * 插入推送管理
     *
     * @param pushManagerDto
     * @return
     */
    Long insert(PushManagerDto pushManagerDto);

    /**
     * 更新推送管理
     *
     * @param pushManagerDto
     * @return
     */
    Integer update(PushManagerDto pushManagerDto);

    /**
     * 根据日期及场景获取推送
     * @param startDate
     * @param endDate
     * @param scenes
     * @return
     */
    PushManagerDto findPushByDateAndType(String startDate, String endDate, Integer scenes);

    /**
     * 通过id查询
     *
     * @param id
     * @return
     */
    PushManagerDto findById(Long id);

    /**
     * 是否启用推送
     *
     * @param id
     * @param enable
     * @return
     */
    Integer openPush(Long id, Integer enable);

    /**
     * 试推送内容给指定销售
     *
     * @param sellerId 指定销售员
     * @param id       推送管理id
     * @return
     */
    Boolean sendToOneSeller(Long sellerId, Long id);

    /**
     * 手动推送
     *
     * @param id 推送管理id
     * @return
     */
    Boolean manualPush(Long id);

    /**
     * 根据推送id删除
     * @param pushId
     * @return
     */
    Boolean deleteById(Long pushId);

}
