package cn.com.duiba.kjy.api.params.content;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * tb_content表简单查询条件
 * @author lizhi
 * @date 2019/12/18 11:35 AM
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ContentSimpleSearchParams extends PageQuery {

    private static final long serialVersionUID = -999111342717579846L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 标题搜索 左匹配
     */
    private String title;

    /**
     * 状态搜索
     */
    private Integer status;

    /**
     * 内容类型
     */
    private String contentType;

    /**
     * 是否推荐，0=不是、1=是
     */
    private Integer recommend;

    /**
     * 归属：1=公有,0=私有
     */
    private Integer publicly;

    /**
     * 是否是销售员上传的
     * @see cn.com.duiba.kjy.api.enums.ContentSellerImportEnum
     */
    private Integer sellerImport;

    /**
     * 多个内容类型
     */
    private List<String> contentTypeList;

    /**
     * 多状态
     */
    private List<Integer> statusList;
}
