package cn.com.duiba.kjy.api.remoteservice.content;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.ContentPositiveEnergy.ContentPositiveEnergyDto;
import cn.com.duiba.kjy.api.params.content.ContentPositiveEnergyParam;

import java.util.List;

/**
 * @Author chentiecheng
 * @Date 2019/12/27 2:12 下午
 */
@AdvancedFeignClient
public interface RemoteContentPositiveEnergyService {
    /**
     /**
     * 查询正能量文章列表
     * @param param
     * @return
     */
    List<ContentPositiveEnergyDto> selectPageList(ContentPositiveEnergyParam param);
    /**
     * 查询记录总数
     * @param param
     * @return
     */
    Long selectCounts(ContentPositiveEnergyParam param);

    /**
     * 根据文章id列表查询
     * @param param
     * @return
     */
    List<ContentPositiveEnergyDto> selectPageListByContentIds(ContentPositiveEnergyParam param);

    /**
     * 根据文章id列表集合查询记录总数
     * @param param
     * @return
     */
    Long selectCountByContentIds(ContentPositiveEnergyParam param);


}
