package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.ActivityClueDto;
import cn.com.duiba.kjy.api.params.ActivityClueParam;

import java.util.List;

/**
 * @author wangbinbin
 * @create 2019-11-08 14:29
 * @descript 活动线索
 */
@AdvancedFeignClient
public interface RemoteActivityClueService {

    /**
     * 添加线索
     * @param clueId
     * @return
     */
    Integer addClue(Long clueId);

    /**
     * 上移 下移
     * @param clueId
     * @param moveType
     * @return
     */
    Boolean move(Long clueId, Integer moveType);

    /**
     * 删除线索
     * @param clueId
     * @return
     */
    Integer deleteByClueId(Long clueId);

    /**
     * 分页查询内容线索列表
     * @param activityClueParam
     * @return
     */
    List<ActivityClueDto> findByPage(ActivityClueParam activityClueParam);

    /**
     * 查询线索总数
     * @param activityClueParam
     * @return
     */
    Integer countByPage(ActivityClueParam activityClueParam);
}
