package cn.com.duiba.kjy.api.remoteservice.content;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.ContentDto;

import java.util.List;

/**
 * @Author chentiecheng
 * @Date 2020/1/2 10:04 上午
 */
@AdvancedFeignClient
public interface RemoteContentUsedRecordService {
    /**
     * 根据标签查找未使用的文章id
     * @param tagId
     * @return
     */
    List<ContentDto> selectContentIdByTag(Long tagId);

    /**
     * 通过删除文章类似更新文章使用记录
     * @param contentIds
     */
    void insertOrUpdateRecordByDeleteContent(List<Long> contentIds);

    /**
     * 根据文章操作 新增或更新文章使用记录
     * @param isInsert 是否是插入， true：插入，false 更新
     * @param contentId
     * @param composeTag
     */
    void insertOrUpdateRecordByArticle(boolean isInsert,Long contentId, Long composeTag);

    /**
     * 根据早报操作 新增或更新文章使用记录
     * @param isInsert 是否是插入， true：插入，false 更新
     * @param dailyId  早报id
     * @param content
     */
    void insertOrUpdateRecordByDaily(boolean isInsert,Long dailyId,String content);

    /**
     * 根据夜读操作 新增或更新文章使用记录
     * @param evenId  夜读id
     * @param contentId 文章id
     */
    void insertOrUpdateRecordByEvening(Long evenId,Long contentId);

    /**
     * 根据文章id获取排版二级标签
     * @param contentId
     * @return
     */
    Long selectTagIdByContentId(Long contentId);
}
