package cn.com.duiba.kjy.api.remoteservice.honorauth;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.constant.KjyCenterException;
import cn.com.duiba.kjy.api.dto.honorauth.HonorAuthDto;
import cn.com.duiba.kjy.api.params.honorauth.HonorAuthMoveParam;

import java.util.List;

/**
 * @author 吴文哲
 * @date 2019-12-30 15:52
 **/
@AdvancedFeignClient
public interface RemoteHonorAuthService {

    /**
     * 荣誉认证列表 以sort正序展示
     * @return
     */
    List<HonorAuthDto> getAll();

    /**
     * 获取已开启的荣誉认证
     * @return
     */
    List<HonorAuthDto> getAllNormalList();

    /**
     * 新增/修改 荣誉认证
     * @param dto
     * @return
     */
    Integer addOrUpdate(HonorAuthDto dto) throws KjyCenterException;

    /**
     * 删除 荣誉认证
     * @return
     */
    Integer delHonorAuth(Long id);

    /**
     * 移动 荣誉认证
     * @return
     */
    Boolean moveHonorAuth(HonorAuthMoveParam moveParam) throws Exception;

    /**
     * 根据主键查询
     * @param id
     * @return
     */
    HonorAuthDto findById(Long id);
}
