package cn.com.duiba.kjy.api.enums.fission;

/**
 * 奖品标签
 * @author：刘超
 * @Date 2019/12/13 14:27
 * @Version 1.0
 */
public enum FissionAwardLabelEnum {

    AUDIO("audio", "音频课程", "//yun.dui88.com/kjy-fission-web/icons/award-type-label/audio.png"),

    VIDEO("video", "视频课程", "//yun.dui88.com/kjy-fission-web/icons/award-type-label/video.png"),

    BOOK("book","电子书", "//yun.dui88.com/kjy-fission-web/icons/award-type-label/book.png"),

    RED_PACKET("red_packet", "红包", "//yun.dui88.com/kjy-fission-web/icons/award-type-label/red-envelope.png"),

    GIFT("gift", "礼物", "//yun.dui88.com/kjy-fission-web/icons/award-type-label/gift.png"),

    ;

    private String code;
    private String desc;
    /**
     * 标签图片
     */
    private String image;

    FissionAwardLabelEnum(String code, String desc, String image) {
        this.code = code;
        this.desc = desc;
        this.image = image;
    }

    public static FissionAwardLabelEnum getByCode(String code) {
        for (FissionAwardLabelEnum enumVal : FissionAwardLabelEnum.values()) {
            if (enumVal.getCode().equals(code)) {
                return enumVal;
            }
        }
        return null;
    }

    public static FissionAwardLabelEnum getByDesc(String desc) {
        for (FissionAwardLabelEnum enumVal : FissionAwardLabelEnum.values()) {
            if (enumVal.getDesc().equals(desc)) {
                return enumVal;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    public String getImage() {
        return image;
    }
}
