package cn.com.duiba.kjy.api.enums.push;

import java.util.HashMap;
import java.util.Map;

/**
 * @author lizhi
 * @date 2019/6/25 11:18 AM
 */
public enum PushSwitchEnum {
    //销售员推送开启/关闭状态
    CLOSE(0, "关闭"),
    OPEN(1, "开启"),
    ;

    private int code;

    private String desc;

    PushSwitchEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static final Map<Integer, PushSwitchEnum> ENUM_MAP = new HashMap<>();

    static{
        for(PushSwitchEnum switchEnum : values()){
            ENUM_MAP.put(switchEnum.getCode(), switchEnum);
        }
    }

    public static PushSwitchEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
