package cn.com.duiba.kjy.api.params.interaction;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author lizhi
 * @date 2019/9/19 4:25 PM
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class ContentInteractionSearchParams extends PageQuery {

    private static final long serialVersionUID = -281102671927988289L;

    /**
     *
     *内容id
     */
    private Long contentId;

    /**
     *
     *互动类型 0问答题单选 1问答题多选 2投票单选 3投票多选
     */
    private Byte interactionType;

    /**
     *
     *标题
     */
    private String title;

    /**
     *
     *是否启用配置
     * @see cn.com.duiba.kjy.api.enums.interaction.InteractionEnableConfigEnum
     */
    private Byte enableConfig;

    /**
     * 互动来源- 0-文章内配置的互动，1-互动题库，2-销售员模板，3-销售员配置
     * @see cn.com.duiba.kjy.api.enums.interaction.InteractionSourceEnum
     */
    private Integer interactionSource;
}
