package cn.com.duiba.kjy.api.remoteservice.fission;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.fission.FissionAwardResourceDto;

import java.util.List;

/**
 * @author : liuchao1@duiba.com.cn
 * @version V1.0
 * @date 2019年11月05日 20:17
 **/
@AdvancedFeignClient
public interface RemoteFissionAwardResourceService {

    /**
     * 根据奖品id查询
     * @param awardId
     * @return
     */
    List<FissionAwardResourceDto> findByAwardId(Long awardId);

    /**
     * 根据活动id查询第一个奖品资源
     * @param awardId
     * @return
     */
    FissionAwardResourceDto findFirstByAwardId(Long awardId);

    /**
     * 根据id查询
     * @param id 主键
     * @return 奖品内容
     */
    FissionAwardResourceDto findById(Long id);

    /**
     * 新增或更新
     * @param dto 奖品内容
     * @return 主键
     */
    Long saveOrUpdate(FissionAwardResourceDto dto);

    /**
     * 调整内容顺序
     * @param id 主键
     * @param target 移至第几位
     * @return 执行结果
     */
    int moveResourceOrder(Long id, int target);

    /**
     * 获取当前奖品下，内容顺序最大值
     * @param awardId 奖品ID
     * @return 顺序最大值
     */
    int findMaxOrder(Long awardId);
}
