package cn.com.duiba.kjy.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.constant.KjyCenterException;
import cn.com.duiba.kjy.api.dto.seller.VipSellerTransferDto;
import cn.com.duiba.kjy.api.dto.seller.VipSellerTransferListDto;
import cn.com.duiba.kjy.api.dto.vipTransfer.VipTransferDto;
import cn.com.duiba.kjy.api.params.seller.VipTransferParam;
import cn.com.duiba.kjy.api.params.seller.VipTransferQueryParam;

import java.util.List;

/**
 * 付费代理迁移
 * @author 吴文哲
 * @date 2020-01-20 13:42
 **/
@AdvancedFeignClient
public interface RemoteVipTransferService {

    /**
     * 根据代理人id获取 迁移对象
     * @param sellerId
     * @return
     */
    VipSellerTransferDto getBySellerId(Long sellerId) throws KjyCenterException;

    /**
     * 分页查询
     * @param param
     * @return
     */
    List<VipSellerTransferListDto> getListByParam(VipTransferQueryParam param) throws KjyCenterException;

    /**
     * 统计总数
     * @param param
     * @return
     */
    Integer countByParam(VipTransferQueryParam param) throws KjyCenterException;


    /**
     * 进行迁移
     * @return
     */
    Boolean doTransfer(VipTransferParam param) throws KjyCenterException;

}
