package cn.com.duiba.kjy.api.params.pay;

import cn.com.duiba.kjy.api.params.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author lizhi
 * @date 2020/1/6 12:21 PM
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class WxDuiBaRefundRecordParam extends PageQuery {

    private static final long serialVersionUID = -4680056965883714418L;

    /**
     * 客集集订单号
     */
    private String bizOrderNo;

    /**
     * 兑吧分配给业务方的类型和bizOrderNo配合使用
     */
    private Integer bizType;

    /**
     * 第三方支付支付流水号,微信支付订单号
     */
    private String transactionNo;

    /**
     * 调用兑吧退款，返回的退款单号
     */
    private String refundOrderNo;

    /**
     * 微信退款单号，兑吧返回
     */
    private String refundNo;

    /**
     * 支付状态，兑吧返回
     */
    private Integer refundStatus;

    /**
     * 客集集业务类型
     */
    private Integer kjjBizType;

    /**
     * 客集集业务对应表的主键
     */
    private Long kjjBizId;
}
