package cn.com.duiba.kjy.api.enums.config;

import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * 代理人配置key枚举
 *
 * @author 吴文哲
 * @date 2019-11-19 15:35
 **/
public enum SellerConfigKeyEnum {
    CARD_SHOW_ON_TOP("card_show_on_top", "向客户展示素材顶部名片",true),
    CARD_SHOW_ON_BOTTOM("card_show_on_bottom", "向客户展示素材底部名片",true),
    @Deprecated
    CARD_MDRT_AUTH("card_MDRT_auth", "MDRT认证开关",false),
    @Deprecated
    CARD_CMF_AUTH("card_CMF_auth", "CMF认证开关",false),
    @Deprecated
    CARD_IDA_AUTH("card_IDA_auth", "IDA认证开关",false),
    NEW_YEAR_ACTIVITY_MUSIC("new_year_activity_music", "元旦活动背景音乐", ""),
    GAME_SHOW_ON_BOTTOM("game_show_on_bottom", "文章内自动推荐小游戏给客户", true),
    RISK_ASSESSMENT_SHOW_ON_BUTTON("risk_assessment_show_on_bottom", "向客户展示风险评测", true),
    QUESTION_SHOW_ON_BUTTON("question_show_on_button", "向客户展示互助问答", true),
    RECOMMEND_SHOW_ON_BUTTON("recommend_show_on_bottom", "向客户展示推荐你看", true),
    JOB_ASSESSMENT_ON_BUTTON("job_assessment_show_on_bottom", "向客户展示职业评测", true),
    JOB_RECRUIT_ON_BUTTON("job_recruit_show_on_bottom", "向客户展示岗位热招", true),
    INVITE_ON_BUTTON("invite_show_on_bottom", "向客户展示创说会邀约", true),
    CARD_PROFESSIONAL_AVATAR("card_professional_avatar", "名片专业头像风格风格", ""),
    ;


    /**
     * 键  长度限制30
     */
    private String key;
    /**
     * 描述  长度限制500
     */
    private String desc;

    private Object defaultVal;

    SellerConfigKeyEnum(String key, String desc,Object defaultVal) {
        this.key = key;
        this.desc = desc;
        this.defaultVal = defaultVal;
    }

    public String getKey() {
        return key;
    }

    public String getDesc() {
        return desc;
    }


    public Object getDefaultVal() {
        return defaultVal;
    }

    private static final Map<String, SellerConfigKeyEnum> ENUM_MAP = new HashMap<>();

    private static final List<String> BOOLEAN_LIST = new ArrayList<>();

    /**
     * 与名片相关的属性
     */
    public static final List<String> SELLER_CARD_AUTH_LIST = new ArrayList<>();

    static{
        for(SellerConfigKeyEnum configEnum : values()){
            ENUM_MAP.put(configEnum.getKey(), configEnum);
        }
        //添加boolean类型的枚举
        BOOLEAN_LIST.addAll(Arrays.asList(CARD_SHOW_ON_TOP.getKey(),CARD_SHOW_ON_BOTTOM.getKey(),CARD_MDRT_AUTH.getKey(),
                CARD_CMF_AUTH.getKey(),CARD_IDA_AUTH.getKey(), GAME_SHOW_ON_BOTTOM.getKey()));
        SELLER_CARD_AUTH_LIST.addAll(Arrays.asList(CARD_SHOW_ON_TOP.getKey(),CARD_SHOW_ON_BOTTOM.getKey(),CARD_MDRT_AUTH.getKey(),
                CARD_CMF_AUTH.getKey(),CARD_IDA_AUTH.getKey()));
    }

    public static SellerConfigKeyEnum getByType(String  key) {
        if (key == null) {
            return null;
        }
        return ENUM_MAP.get(key);
    }

    /**
     * 是否包含
     * @param key
     * @return
     */
    public static boolean contains(String key){
        if (StringUtils.isBlank(key)){
            return false;
        }
        for (SellerConfigKeyEnum enumVal : SellerConfigKeyEnum.values()) {
            if (Objects.equals(enumVal.getKey(),key)) {
                return true;
            }
        }
        return false;
    }

    /**
     * 获取所有的Boolean类型的枚举
     * @return
     */
    @Deprecated
    public static List<String> getBooleanEnums() {
        return BOOLEAN_LIST;
    }
}
