/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.constant;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public enum ContentTypeEnum {
    ARTICLE("article", "\u6587\u7ae0"),
    ACTIVITY("activity", "\u6d3b\u52a8"),
    DAILY("daily", "\u65e9\u62a5"),
    POSTER("poster", "\u6d77\u62a5"),
    AFTERNOON("afternoon", "\u5348\u540e\u8bdd\u9898"),
    EVENING("evening", "\u665a\u5b89\u5fc3\u8bed"),
    GAME_LOTTERY("game_lottery", "\u62bd\u5956\u5de5\u5177"),
    GAME_TEMPLATE("game_template", "\u62bd\u5956\u6a21\u677f"),
    GAME_ANSWER("game_answer", "\u8da3\u5473\u6d4b\u8bd5"),
    GAME_ANIMATION("game_animation", "\u52a8\u753b"),
    GREETING_CARD("greeting_card", "\u8282\u65e5\u8d3a\u5361"),
    SELLER("seller", "\u9500\u552e\u5458\u540d\u7247"),
    SELLER_CARD("card", "\u540d\u7247\u5206\u4eab"),
    OUTER_MARKET("outer_market", "\u8170\u5c01\u81ea\u5b9a\u4e49\u94fe\u63a5"),
    OUTER_EXCLUSIVE("outer_exclusive", "\u4e13\u533a\u81ea\u5b9a\u4e49\u94fe\u63a5"),
    WEEKLY_PUBLICATION("weekly_publication", "\u4ee3\u7406\u4eba\u5468\u62a5"),
    NETWORK_LINK("network_link", "\u5168\u7f51\u94fe\u63a5"),
    VIDEO("video", "\u89c6\u9891"),
    SPECIAL_TOPIC("special_topic", "\u9996\u9875\u4e13\u9898\u7c7b\u578b");

    private String code;
    private String desc;
    private static final Map<String, ContentTypeEnum> ENUM_MAP;

    private ContentTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public static ContentTypeEnum getByCode(String code) {
        ContentTypeEnum result = ENUM_MAP.get(code);
        if (result == null) {
            return null;
        }
        return result;
    }

    public static boolean isContent(String type) {
        return StringUtils.equals((String)type, (String)ContentTypeEnum.ARTICLE.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.ACTIVITY.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.DAILY.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.POSTER.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.AFTERNOON.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.EVENING.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.GAME_LOTTERY.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.GAME_TEMPLATE.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.GAME_ANIMATION.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.GAME_ANSWER.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.GREETING_CARD.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.VIDEO.code);
    }

    public static boolean isNeedAnalyse(String type) {
        return StringUtils.equals((String)type, (String)ContentTypeEnum.ARTICLE.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.ACTIVITY.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.DAILY.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.EVENING.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.OUTER_EXCLUSIVE.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.OUTER_MARKET.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.GAME_LOTTERY.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.GAME_TEMPLATE.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.GAME_ANIMATION.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.GAME_ANSWER.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.NETWORK_LINK.code);
    }

    public static boolean isPaper(String type) {
        return StringUtils.equals((String)type, (String)ContentTypeEnum.DAILY.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.AFTERNOON.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.EVENING.code);
    }

    public static List<String> getUnNeedAnalyseTypes() {
        ArrayList<String> resultList = new ArrayList<String>();
        resultList.add(POSTER.getCode());
        resultList.add(SELLER_CARD.getCode());
        return resultList;
    }

    public static boolean isMarket(String type) {
        return StringUtils.equals((String)type, (String)ContentTypeEnum.OUTER_MARKET.code);
    }

    public static boolean isSellerCard(String type) {
        return StringUtils.equals((String)type, (String)ContentTypeEnum.SELLER_CARD.code);
    }

    public static boolean isExclusive(String type) {
        return StringUtils.equals((String)type, (String)ContentTypeEnum.OUTER_EXCLUSIVE.code);
    }

    public static boolean isSeller(String type) {
        return StringUtils.equals((String)type, (String)ContentTypeEnum.SELLER.code);
    }

    public static boolean isActivity(String type) {
        return StringUtils.equals((String)type, (String)ContentTypeEnum.ACTIVITY.code) || ContentTypeEnum.isGameActivity(type);
    }

    public static boolean isGameActivity(String type) {
        return ContentTypeEnum.isGameH5Activity(type) || StringUtils.equals((String)type, (String)ContentTypeEnum.GAME_TEMPLATE.code);
    }

    public static boolean isGameH5Activity(String type) {
        return StringUtils.equals((String)type, (String)ContentTypeEnum.GAME_LOTTERY.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.GAME_ANSWER.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.GAME_ANIMATION.code);
    }

    public static List<String> getGameActivityContentTypes() {
        ArrayList<String> list = new ArrayList<String>();
        for (ContentTypeEnum typeEnum : ContentTypeEnum.values()) {
            if (!ContentTypeEnum.isGameH5Activity(typeEnum.code)) continue;
            list.add(typeEnum.code);
        }
        return list;
    }

    public static boolean isNoviceTaskArticleType(String type) {
        return StringUtils.equals((String)type, (String)ContentTypeEnum.ARTICLE.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.DAILY.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.EVENING.code);
    }

    public static boolean isNoviceTaskActivityType(String type) {
        return StringUtils.equals((String)type, (String)ContentTypeEnum.ACTIVITY.code);
    }

    public static boolean isNetworkLink(String type) {
        return StringUtils.equals((String)type, (String)ContentTypeEnum.NETWORK_LINK.code);
    }

    public static boolean isClueContentType(String type) {
        return StringUtils.equals((String)type, (String)ContentTypeEnum.ARTICLE.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.ACTIVITY.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.DAILY.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.EVENING.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.GAME_ANSWER.code);
    }

    static {
        ENUM_MAP = new HashMap<String, ContentTypeEnum>();
        for (ContentTypeEnum type : ContentTypeEnum.values()) {
            ENUM_MAP.put(type.getCode(), type);
        }
    }
}

