package cn.com.duiba.kjy.api.dto.novice;

import cn.com.duiba.kjy.api.enums.novice.SellerNoviceTaskStatusEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * @author wangbinbin
 * @create 2019-09-04 13:42
 * @descript
 */
@Data
public class SellerNoviceTaskDto implements Serializable {

    private static final long serialVersionUID = 6838585895184493746L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 代理人id
     */
    private Long sellerId;

    /**
     * 新手任务id
     */
    private Long taskId;

    /**
     * 任务名称
     */
    private String taskName;

    /**
     * 任务描述
     */
    private String taskDescription;

    /**
     * 任务奖励金额
     */
    private Integer taskPrize;

    /**
     * 任务完成进度
     */
    private Integer taskCompletionSchedule;

    /**
     * 任务完成目标数
     */
    private Integer taskCompletionTimes;

    /**
     * 任务状态 0-任务未完成 1-可领取奖励 2-任务已完成
     * @see SellerNoviceTaskStatusEnum
     */
    private Integer taskStatus;


}
