package cn.com.duiba.kjy.api.dto.redpacket;

import cn.com.duiba.kjy.api.enums.pay.ChargeStatusEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 销售员红包配置表
 * @author kjj mybatis generator
 * @date 2020-01-07
 */
@Data
public class SellerRedPacketConfDto implements Serializable {

    private static final long serialVersionUID = 5384898072032588998L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 红包对应的业务id
     */
    private Long redPacketBizId;

    /**
     * 红包对应的业务类型
     * @see cn.com.duiba.kjy.api.enums.redpacket.RedPacketBizTypeEnum
     */
    private Integer redPacketBizType;

    /**
     * 祝福语
     */
    private String blessWord;

    /**
     * 单个红包金额
     */
    private Integer singleAmount;

    /**
     * 总红包个数
     */
    private Integer totalNum;

    /**
     * 剩余个数
     */
    private Integer surplusNum;

    /**
     * 总金额
     */
    private Integer totalAmount;

    /**
     * 优惠金额
     */
    private Integer promotionAmount;

    /**
     * 支付金额
     */
    private Integer payAmount;

    /**
     * 剩余金额
     */
    private Integer surplusAmount;

    /**
     * 已领取金额
     */
    private Integer receivedAmount;

    /**
     * 支付成功时间
     */
    private Date paySuccessTime;

    /**
     * 客集集订单号
     */
    private String bizOrderNo;

    /**
     * 支付状态
     * @see cn.com.duiba.kjy.api.enums.pay.ChargeStatusEnum
     */
    private Integer chargeStatus;

    /**
     * 退款状态
     * @see cn.com.duiba.kjy.api.enums.pay.RefundStatusEnum
     */
    private Integer refundStatus;

    /**
     * 优惠id，对应tb_seller_promotion.id
     */
    private Long promotionId;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    private static final Long EXPIRE_TIME = 24*60*60*1000L;

    /**
     * 是否可以领取红包
     * @return true-可以领取， false-失败
     */
    public boolean canReceived() {
        if (!ChargeStatusEnum.isPaySuccess(chargeStatus)) {
            return false;
        }
        if (refundStatus != null && refundStatus > 0) {
            return false;
        }
        if (surplusNum == null || surplusNum <= 0) {
            return false;
        }
        if (surplusAmount == null || surplusAmount <= 0) {
            return false;
        }
        if (paySuccessTime == null) {
            return false;
        }
        Date now = new Date();
        if (now.getTime() < paySuccessTime.getTime()) {
            //异常情况
            return false;
        }
        return now.getTime() - paySuccessTime.getTime() < EXPIRE_TIME;
    }

    public boolean expire() {
        if (paySuccessTime == null) {
            return false;
        }
        Date now = new Date();
        if (now.getTime() < paySuccessTime.getTime()) {
            //异常情况
            return false;
        }
        return now.getTime() - paySuccessTime.getTime() >= EXPIRE_TIME;
    }
}
